<?php
/**
 * 2007-2021 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 * 
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 *  @author ETS-Soft <etssoft.jsc@gmail.com>
 *  @copyright  2007-2021 ETS-Soft
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

if (!defined('_PS_VERSION_'))
	exit;
class Ets_hd_mailtraciking extends ObjectModel
{
    public $id_ets_hd_mailqueue;
    public $id_customer;
    public $id_employee;
    public $customer_name;
    public $email;
    public $status;
    public $queue_date;
    public $date_add;
    public static $definition = array(
		'table' => 'ets_hd_mailtraciking',
		'primary' => 'id_ets_hd_mailtraciking',
		'multilang' => false,
		'fields' => array(
            'id_ets_hd_mailqueue' => array('type' => self::TYPE_INT),
            'id_customer' => array('type' => self::TYPE_INT),
            'id_employee' => array('type' => self::TYPE_INT),
            'customer_name' => array('type' => self::TYPE_STRING),
            'email' => array('type' => self::TYPE_STRING),
            'status' => array('type' => self::TYPE_STRING),
            'queue_date' => array('type' => self::TYPE_DATE),
            'date_add' => array('type' => self::TYPE_DATE),
        )
	);
    public	function __construct($id_item = null, $id_lang = null, $id_shop = null)
	{
		parent::__construct($id_item, $id_lang, $id_shop);
	}
    public static function getMailtrackingByQueue($id_ets_hd_mailqueue)
    {
        if(($id_ets_hd_mailtraciking = (int)Db::getInstance()->getValue('SELECT id_ets_hd_mailtraciking FROM `'._DB_PREFIX_.'ets_hd_mailtraciking` WHERE id_ets_hd_mailqueue='.(int)$id_ets_hd_mailqueue)))
        {
            return new Ets_hd_mailtraciking($id_ets_hd_mailtraciking);
        }
        else
        {
            $mailTracking = new Ets_hd_mailtraciking();
            $mailTracking->id_ets_hd_mailqueue = (int)$id_ets_hd_mailqueue;
            return $mailTracking;
        }
    }
    public static function getMailTrackings($filter='',$sort='',$start=0,$limit=10,$total=false)
    {
        if($total)
            return Db::getInstance()->getValue('SELECT COUNT(DISTINCT id_ets_hd_mailtraciking) FROM `'._DB_PREFIX_.'ets_hd_mailtraciking` m WHERE 1 '.($filter ? :''));
        else
        {
           $mail_tracikings = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.'ets_hd_mailtraciking` m WHERE 1 '.($filter ? :'').($sort ? ' ORDER BY '.$sort: ' ORDER BY m.id_ets_hd_mailtraciking DESC').($limit ? ' LIMIT '.(int)$start.','.(int)$limit.'':''));
           return $mail_tracikings;
            
        }
    }
    public static function deleteSelected($ids)
    {
        if($ids && is_array($ids))
        {
            return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'ets_hd_mailtraciking` WHERE id_ets_hd_mailtraciking IN ('.implode(',',array_map('intval',$ids)).')');
        }
    }
}