<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

class HDCustomer extends ObjectModel
{
    public $id_customer;
    public $avatar;

    public static $definition = array(
        'table' => 'ets_hd_customer',
        'primary' => 'id_customer',
        'fields' => array(
            'id_customer' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'avatar' => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
        ),
    );

    public function __construct($id = null, $id_lang = null, $id_shop = null)
    {
        parent::__construct($id, $id_lang, $id_shop);
        if ($id) {
            $this->id_customer = $id;
        }
    }

    public static function getAvatar($id_customer)
    {
        if (!$id_customer ||
            !Validate::isUnsignedId($id_customer)
        ) {
            return '';
        }

        return Db::getInstance()->getValue('SELECT `avatar` FROM `' . _DB_PREFIX_ . 'ets_hd_customer` WHERE id_customer=' . (int)$id_customer);
    }
}