<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

if (!defined('_PS_VERSION_'))
    exit;

class HDHelperList extends HDTranslate
{
    public $list_id;
    public $fields_list;
    public $list;
    public $paginates = array();
    public $list_per_pages = array();
    public $tpl_vars = array();
    public $table;
    public $context;
    public $module;
    public $title;
    public $filter;
    public $show_footer_btn;
    public $total_records;
    public $current_per_page;
    public $link;
    public $current_sort_by;
    public $actions = array();

    public function __construct()
    {
        $this->list_id = uniqid();
        $this->context = Context::getContext();
    }

    public function generalList()
    {
        $search_field = false;
        $date = true;
        if ($this->fields_list) {
            foreach ($this->fields_list as $field) {
                if (isset($field['search']) && $field['search'] && !$search_field) {
                    $search_field = true;
                }
                if (trim($field['type']) == 'date') {
                    $field['class'] = 'datepicker';
                    if ($search_field && $date) {
                        $this->context->controller->addJqueryUI('ui.datepicker');
                        $date = false;
                    }
                }
            }
        }
        $this->context->smarty->assign(array_merge(array(
            'title' => $this->title,
            'table' => $this->table,
            'list' => $this->list,
            'fields_list' => $this->fields_list,
            'paginates' => $this->paginates,
            'list_per_pages' => $this->list_per_pages,
            'show_footer_btn' => $this->show_footer_btn,
            'current_per_page' => $this->current_per_page,
            'total_records' => $this->total_records,
            'filter' => $this->filter,
            'current_sort_by' => $this->current_sort_by,
            'link' => $this->link,
            'search_field' => $search_field,
        ), $this->tpl_vars));

        return $this->context->smarty->fetch(_PS_MODULE_DIR_ . $this->module->name . '/views/templates/hook/bo-fo-helper-list.tpl');
    }
}