<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

class HDOption extends ObjectModel
{
    public $title;
    public $default;

    public static $definition = array(
        'table' => 'ets_hd_option',
        'primary' => 'id_ets_hd_option',
        'multilang' => true,
        'fields' => array(
            // Lang fields
            'default' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'title' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'size' => 255),
        )
    );

    /**
     * @param $id_ets_hd_column
     * @param null $idLang
     * @return array|false
     */
    public static function getOptions($id_ets_hd_column, $idLang = null)
    {
        if ($id_ets_hd_column <= 0 ||
            !Validate::isUnsignedInt($id_ets_hd_column)
        ) {
            return false;
        }

        $dq = new DbQuery();
        $dq
            ->select('co.id_ets_hd_option, o.`default`, ol.id_lang, ol.title')
            ->from('ets_hd_column_option', 'co')
            ->leftJoin('ets_hd_option', 'o', 'o.id_ets_hd_option = co.id_ets_hd_option')
            ->leftJoin('ets_hd_option_lang', 'ol', 'ol.id_ets_hd_option = o.id_ets_hd_option')
            ->where('co.id_ets_hd_column = ' . (int)$id_ets_hd_column)
            ->orderBy('co.position ASC')
        ;

        if ($idLang > 0) {
            $dq
                ->select('co.id_ets_hd_option as id')
                ->where('ol.id_lang = ' . (int)$idLang);
        }
        $res = Db::getInstance()->executeS($dq);
        if ($idLang > 0) {
            return $res;
        }
        $options = array();
        if (is_array($res) && count($res) > 0) {
            foreach ($res as $op) {
                $options[(int)$op['id_ets_hd_option']]['id_ets_hd_option'] = (int)$op['id_ets_hd_option'];
                $options[(int)$op['id_ets_hd_option']]['title'][(int)$op['id_lang']] = $op['title'];
                $options[(int)$op['id_ets_hd_option']]['default'] = $op['default'];
            }
        }

        return $options;
    }
}