<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

if (!defined('_PS_VERSION_'))
    exit;

class HDTools
{
    public static function quickSort($list, $field = 'position', $ignore_value = -1)
    {
        $left = $right = array();
        if (count($list) <= 1) {
            return $list;
        }
        $pivot_key = key($list);
        $pivot = array_shift($list);
        // partial:
        foreach ($list as $key => $val) {
            if ($val[$field] <= $pivot[$field]) {
                $left[$key] = $val;
            } elseif ($val[$field] > $pivot[$field]) {
                $right[$key] = $val;
            }
        }
        // recursive:
        return array_merge(self::quickSort($left, $field, $ignore_value), array($pivot_key => $pivot), self::quickSort($right, $field, $ignore_value));
    }

    public static function lastNumber($number_len)
    {
        $str_number = '';
        for ($i = 1; $i <= (int)$number_len; $i++)
            $str_number .= '9';
        return (int)$str_number;
    }

    public static function getServerVars($var)
    {
        return isset($_SERVER[$var]) ? $_SERVER[$var] : '';
    }

    public static function getPostMaxSizeBytes()
    {
        $postMaxSizeList = array(@ini_get('post_max_size'), @ini_get('upload_max_filesize'), (int)Configuration::get('PS_ATTACHMENT_MAXIMUM_SIZE') . 'M');
        $ik = 0;
        foreach ($postMaxSizeList as &$max_size) {
            $bytes = (int)trim($max_size);
            $last = Tools::strtolower($max_size[Tools::strlen($max_size) - 1]);
            switch ($last) {
                case 'g':
                    $bytes *= 1024;
                case 'm':
                    $bytes *= 1024;
                case 'k':
                    $bytes *= 1024;
            }
            if ($bytes == '') {
                unset($postMaxSizeList[$ik]);
            } else
                $max_size = $bytes;
            $ik++;
        }

        return min($postMaxSizeList);
    }

    public static function getNewFilename($folder)
    {
        do {
            $filename = sha1(Tools::strtolower(Tools::passwdGen(32)));
        } while (file_exists($folder . $filename));

        return $filename;
    }

    /**
     * home|cat|large|medium
     * @param $image_type
     * @return string
     */
    public static function getImageType($image_type)
    {
        return version_compare(_PS_VERSION_, '1.7.0.0', '>') ? ImageType::getFormattedName($image_type) : ImageType::getFormatedName($image_type);
    }

    /**
     * @param $array_values
     * @param $key
     * @param $value
     * @return bool
     */
    public static function valueOfList($array_values, $key, $value)
    {
        if (is_array($array_values)
            && count($array_values)
        ) {
            foreach ($array_values as $array_value) {
                if (trim($key) !== ''
                    && isset($array_value[$key])
                    && trim($array_value[$key]) == trim($value)
                ) {
                    return true;
                }
            }
        }
        return false;
    }

    public static function recurseCopy($src, $dst)
    {
        if (!@file_exists($src)) {
            return false;
        }
        $dir = opendir($src);
        if (!is_dir($dst) && !@mkdir($dst)) {
            return false;
        }
        while (false !== ($file = readdir($dir))) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    self::recurseCopy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    @copy($src . '/' . $file, $dst . '/' . $file);
                }
            }
        }
        closedir($dir);
        return true;
    }

    public static function recursiveUnlink($dir, $pattern_ignore_files = array())
    {
        if (@is_dir($dir)) {
            $files = array_diff(scandir($dir), array('.', '..'));
            foreach ($files as $file) {
                if (is_dir(($each = $dir . DIRECTORY_SEPARATOR . $file))) {
                    self::recursiveUnlink($each);
                } elseif ($pattern_ignore_files) {
                    $flag = 1;
                    foreach ($pattern_ignore_files as $pattern) {
                        if (preg_match($pattern, $file)) {
                            $flag = 0;
                            break;
                        }
                    }
                    if ($flag)
                        @unlink($each);
                } else
                    @unlink($each);
            }
            //@rmdir($dir);
        }

        return true;
    }

    public static function getRecursiveFiles($dir, &$ret, $about_time)
    {
        if (@is_dir($dir)) {
            $files = array_diff(scandir($dir), array('.', '..'));
            foreach ($files as $file) {
                if (is_dir(($each = $dir . DIRECTORY_SEPARATOR . $file))) {
                    self::getRecursiveFiles($each, $ret, $about_time);
                } elseif ($about_time <= 0 || filemtime($each) <= $about_time) {
                    $ret[] = array(
                        'path' => $each,
                        'size' => filesize($each),
                    );
                }
            }
        }

        return $ret;
    }

    public static function formatBytes($bytes, $precision = 2)
    {
        $units = array('B', 'KB', 'MB', 'GB', 'TB');

        $bytes = max($bytes, 0);
        $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
        $pow = min($pow, count($units) - 1);

        // Uncomment one of the following alternatives
        $bytes /= pow(1024, $pow);
        //$bytes /= (1 << (10 * $pow));

        return round($bytes, $precision) . ' ' . $units[$pow];
    }

    public static function formatFileName($file_name)
    {
        return preg_match('/[\_\(\)\s\%\+]+/', '-', $file_name);
    }
}