<?php
/**
 * 2007-2022 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2022 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

require_once dirname(__FILE__) . '/AdminEtsHDFormController.php';

class AdminEtsHDOptionsController extends AdminEtsHDFormController
{

    public function __construct()
    {
        $this->bootstrap = true;

        $this->table = 'ets_hd_option';
        $this->className = 'HDOption';
        $this->list_id = $this->table;
        $this->lang = true;
        $this->show_form_cancel_button = false;
        $this->list_no_link = true;

        parent::__construct();

        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Options'),
            ),
            'submit' => array(
                'title' => $this->l('Add options'),
            ),
            'input' => array(
                'title' => array(
                    'name' => 'title',
                    'label' => $this->l('Title'),
                    'type' => 'text',
                    'lang' => true,
                    'required' => true,
                    'validate' => 'isCleanHtml',
                )
            ),
        );
    }
}