<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

class Ets_helpdeskBaseModuleFrontController extends ModuleFrontController
{
    /**
     * @var Ets_helpdesk
     */
    public $module;
    public $name;
    public $title;
    public $meta_title;
    public $meta_description;
    public $meta_keywords;

    public function __construct()
    {
        parent::__construct();

        if (!$this->module->ps17) {
            $this->display_column_left = false;
            $this->display_column_right = false;
        }
    }

    public function init()
    {
        parent::init();

        $this->module->init();
    }

    public function postProcess()
    {
        $this->module->postProcess();
    }

    public function initContent()
    {
        parent::initContent();

        $tpl_vars = array();
        $body_classes = [
            'lang-' . $this->context->language->iso_code => true,
            'lang-rtl' => (bool)$this->context->language->is_rtl,
            'country-' . $this->context->country->iso_code => true,
            'currency-' . $this->context->currency->iso_code => true,
            'page-' . $this->name => true
        ];
        if ($this->module->ps17) {
            $body_classes[$this->context->shop->theme->getLayoutNameForPage($this->name)] = true;
            $body_classes['tax-display-' . ($this->getDisplayTaxesLabel() ? 'enabled' : 'disabled')] = true;
        }

        $tpl_vars['page'] = array(
            'title' => $this->title,
            'canonical' => '',
            'meta' => array(
                'title' => $this->meta_title ?: $this->title,
                'description' => $this->meta_description,
                'keywords' => $this->meta_keywords,
                'robots' => 'index',
            ),
            'page_name' => $this->name,
            'body_classes' => $body_classes,
            'admin_notifications' => array(),
        );

        if (!$this->module->ps17) {
            $tpl_vars['breadcrumb'] = $tpl_vars['path'] = $this->getBreadcrumb();
            if (count($this->errors)) {
                $tpl_vars['errors'] = $this->errors;
            }
        }
        $id_ets_hd_ticket = Tools::getValue('id_ets_hd_ticket');
        if (Validate::isUnsignedInt($id_ets_hd_ticket) && $id_ets_hd_ticket > 0 || Tools::isSubmit('add_ticket')) {
            $tpl_vars['ticket_link'] = HDLink::getInstance()->getTicketsLink($this->context->language->id, $this->module->extraParams());
        }
        $this->context->smarty->assign($tpl_vars);

        $this->module->initContent();

        $this->setTemplate($this->template);
    }

    public function getBreadcrumb()
    {
        $breadcrumb = $this->getBreadcrumbLinks();
        $breadcrumb['count'] = count($breadcrumb['links']);

        return $this->module->ps17 ? $breadcrumb : $this->displayBreadcrumb($breadcrumb);
    }

    public function displayBreadcrumb($breadcrumb)
    {
        $this->context->smarty->assign('breadcrumb', $breadcrumb);

        return $this->context->smarty->fetch($this->module->getLocalPath() . 'views/templates/front/breadcrumb.tpl');
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = array();
        if ($this->module->ps17) {
            $breadcrumb['links'][] = array(
                'title' => $this->module->l('Home', 'tickets'),
                'url' => $this->context->link->getPageLink('index', true),
            );
        }
        $breadcrumb['links'][] = array(
            'title' => $this->module->l('Your account', 'tickets'),
            'url' => $this->context->link->getPageLink('my-account', true),
        );

        return $breadcrumb;
    }
}