<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

require_once dirname(__FILE__) . '/base.php';

class Ets_helpdeskStaffModuleFrontController extends Ets_helpdeskBaseModuleFrontController
{
    public function __construct()
    {
        parent::__construct();

        $this->module->customer_staff = 1;
    }

    public function init()
    {
        parent::init();

        $this->name = 'staff';
        $this->title = Configuration::get('ETS_HD_STAFF_TITLE', $this->context->language->id);
        $this->meta_description = Configuration::get('ETS_HD_STAFF_META_DESCRIPTION', $this->context->language->id);
        $this->meta_keywords = Configuration::get('ETS_HD_STAFF_META_KEYWORDS', $this->context->language->id);
        $this->meta_title = Configuration::get('ETS_HD_STAFF_META_TITLE', $this->context->language->id);
        $this->template = ($this->module->ps17 ? 'module:' . $this->module->name . '/views/templates/front/' : '') . 'ticket' . ($this->module->ps17 ? '' : '-16') . '.tpl';
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();
        if (trim(Tools::getValue('controller')) === 'staff') {
            $breadcrumb['links'][] = array(
                'title' => $this->module->l('Manager tickets', 'staffs'),
                'url' => HDLink::getInstance()->getTicketsLink($this->context->language->id, $this->module->extraParams()),
            );
            $breadcrumb['links'][] = array(
                'title' => $this->title,
                'url' =>'',
            );
        }
        return $breadcrumb;
    }
}