<?php
/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2022 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

require_once dirname(__FILE__) . '/base.php';

class Ets_helpdeskTicketsModuleFrontController extends Ets_helpdeskBaseModuleFrontController
{
    public function init()
    {
        parent::init();

        $this->title = $this->module->l('My tickets', 'tickets');
        $this->meta_description = Configuration::get('ETS_HD_TICKET_META_DESCRIPTION', $this->context->language->id);
        $this->meta_keywords = Configuration::get('ETS_HD_TICKET_META_KEYWORDS', $this->context->language->id);
        $this->meta_title = Configuration::get('ETS_HD_TICKET_META_TITLE', $this->context->language->id);
        $this->name = 'tickets';
        $this->template = ($this->module->ps17 ? 'module:' . $this->module->name . '/views/templates/front/' : '') . 'ticket' . ($this->module->ps17 ? '' : '-16') . '.tpl';
    }


    public function initContent()
    {
        if ((int)Tools::getValue('conf_msg') === 3) {
            $this->context->smarty->assign(array(
                'conf_msg' => 3
            ));
        }
        parent::initContent(); // TODO: Change the autogenerated stub
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();
        if (trim(Tools::getValue('controller')) === 'tickets') {
            $breadcrumb['links'][] = array(
                'title' => $this->title,
                'url' => HDLink::getInstance()->getTicketsLink($this->context->language->id, $this->module->extraParams()),
            );
            if (Tools::isSubmit('add_ticket')) {
                $breadcrumb['links'][] = array(
                    'title' => Configuration::get('ETS_HD_TICKET_TITLE', $this->context->language->id),
                    'url'=>'',
                );
            }
        }
        return $breadcrumb;
    }
}