/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 *  @author ETS-Soft <etssoft.jsc@gmail.com>
 *  @copyright  2007-2022 ETS-Soft
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

// bo-fo:
var ets_hd_fn_recaptcha = {
    ets_hd_recaptcha_valid: false,
    recaptchaWidgets: [],
    onLoad: function (forms) {
        if (!ETS_HD_ALLOW_CAPTCHA || ETS_HD_CUSTOMER_NO_CAPTCHA) {
            return;
        }
        if (ETS_HD_CAPTCHA_TYPE !== 'recaptcha_v2') {
            this.v3(forms);
        } else {
            this.v2(forms);
        }
    },
    reset: function (form) {
        if (!ETS_HD_ALLOW_CAPTCHA || ETS_HD_CUSTOMER_NO_CAPTCHA) {
            return;
        }
        if (ETS_HD_CAPTCHA_TYPE !== 'recaptcha_v2') {
            form.removeClass('g-loaded');
            this.v3(form);
        } else {
            this.v2Reset(form.attr('id'));
        }
    },
    v2: function (forms) { // Load multi-re-captcha:
        if (!ETS_HD_RECAPTCHA_V2_SITE_KEY ||
            typeof forms === "undefined" ||
            forms.length <= 0 ||
            typeof grecaptcha === "undefined"
        ) {
            return;
        }
        const pattern = /(^|\s)g-recaptcha(\s|$)/;
        for (let i = 0; i < forms.length; i++) {
            if (forms[i].classList.contains('g-loaded')) {
                continue;
            }
            let reCAPTCHAs = forms[i].getElementsByClassName('g-recaptcha');
            for (let k = 0; k < reCAPTCHAs.length; k++) {
                if (reCAPTCHAs[k].className && reCAPTCHAs[k].className.match(pattern)) {
                    this.recaptchaWidgets[forms[i].id] = grecaptcha.render(reCAPTCHAs[k], {
                        'sitekey': ETS_HD_RECAPTCHA_V2_SITE_KEY,
                    });
                    forms[i].classList.add('g-loaded');

                    break;
                }
            }
        }
    },
    v3: function (forms) {// Load multi-re-captcha:
        if (!ETS_HD_RECAPTCHA_V3_SITE_KEY ||
            typeof forms === "undefined" ||
            forms.length <= 0 ||
            typeof grecaptcha === "undefined"
        ) {
            return;
        }
        const pattern = /(^|\s)g-recaptcha-response(\s|$)/;
        let body = document.getElementsByTagName('body'),
            action = body[0].id ? body[0].id.replace(/(?=[^A-Za-z\_])([^A-Za-z\_])/g, '_') : 'submit'
        ;
        for (let i = 0; i < forms.length; i++) {
            if (forms[i].classList.contains('g-loaded')) {
                continue;
            }
            let reCAPTCHAs = forms[i].getElementsByClassName('g-recaptcha-response');
            for (let k = 0; k < reCAPTCHAs.length; k++) {
                if (reCAPTCHAs[k].className && reCAPTCHAs[k].className.match(pattern)) {
                    grecaptcha.ready(function () {
                        grecaptcha.execute(ETS_HD_RECAPTCHA_V3_SITE_KEY, {action: action}).then(function (token) {
                            if (token) {
                                reCAPTCHAs[k].value = token;
                                forms[i].classList.add('g-loaded');
                            }
                        });
                    });

                    break;
                }
            }
        }
    },
    v2Reset: function (id) {
        if (!ETS_HD_RECAPTCHA_V2_SITE_KEY ||
            !ETS_HD_RECAPTCHA_V2_SECRET_KEY ||
            !id
        ) {
            return;
        }
        if (this.recaptchaWidgets && grecaptcha) {
            this.ets_hd_recaptcha_valid = false;
            if (id) {
                grecaptcha.reset(this.recaptchaWidgets[id]);
                this.removeClassError(id);
            } else {
                Object.keys(this.recaptchaWidgets).forEach(function (key) {
                    grecaptcha.reset(this.recaptchaWidgets[key]);
                    this.removeClassError(key);
                });
            }
        }
    },
    removeClassError: function (id) {
        var form = document.getElementById(id);
        if (form.classList.contains('g-loaded')) {
            var ele = form.getElementsByClassName('g-recaptcha');
            if (ele[0].classList.contains('error')) {
                ele[0].classList.remove('error');
            }
        }
    },
};

$(document).ready(function () {
    var reCAPTCHA = $('form.form-g-recaptcha:not(.g-loaded)');
    if (reCAPTCHA.length > 0) {
        ets_hd_fn_recaptcha.onLoad(reCAPTCHA);
    }
});