/**
 * 2007-2022 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 *  @author ETS-Soft <etssoft.jsc@gmail.com>
 *  @copyright  2007-2022 ETS-Soft
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */

// bo-fo:
var ets_hd_change_status_msg = ets_hd_change_status_msg || 'Do you want to change status?',
    ets_hd_change_priority_msg = ets_hd_change_priority_msg || 'Do you want to change priority?',
    ets_hd_not_item_selected = ets_hd_not_item_selected || 'Please choose item?',
    ets_hd_delete_confirm = ets_hd_delete_confirm || 'Do you want to delete this item?',
    ets_hd_max_file_size_msg = ets_hd_max_file_size_msg || 'Max file size',
    ets_hd_allow_ext_file_msg = ets_hd_allow_ext_file_msg || 'File extension is invalid',
    ets_hd_allow_ext_files = ets_hd_allow_ext_files || ['jpg', 'gif', 'jpeg', 'png', 'docx', 'doc', 'pdf', 'zip', 'xls', 'xlsx'],
    ets_hd_post_max_size = ets_hd_post_max_size || 0,
    ets_hd_selected_star = 0
;
if (typeof sendBulkAction == "undefined") {
    function sendBulkAction(form, action) {
        String.prototype.splice = function (index, remove, string) {
            return (this.slice(0, index) + string + this.slice(index + Math.abs(remove)));
        };

        var form_action = $(form).attr('action');

        if (form_action.replace(/(?:(?:^|\n)\s+|\s+(?:$|\n))/g, '').replace(/\s+/g, ' ') == '')
            return false;

        var connect = form_action.indexOf('?') !== -1 ? '&' : '?';

        if (form_action.indexOf('#') == -1)
            $(form).attr('action', form_action + connect + action);
        else
            $(form).attr('action', form_action.splice(form_action.lastIndexOf(connect), 0, connect + action));

        $(form).submit();
    }
}
if (typeof showSuccessMessage == "undefined") {
    function showSuccessMessage(msg) {
        if ($.growl)
            $.growl.notice({title: "", message: msg});
    }
}
if (typeof showErrorMessage == "undefined") {
    function showErrorMessage(msg) {
        if ($.growl)
            $.growl.error({title: "", message: msg});
    }
}

$(document).ready(function () {
    $(document).on('click', '.ets_hd_customer_item .remove_ctm', function () {
        $(this).parents('.ets_hd_customer_search').removeClass('active').find('.ets_hd_customer_item').remove();
        $('#id_customer').val(0);
    });
    if($('.alert-danger').length)
    {
        $('.alert-danger').each(function(){
           if(!$(this).find('.close').length) 
            $(this).prepend('<button class="close" type="button" data-dismiss="alert">×</button>'); 
        });
    }
    //if($('.ets_hd_alert_success').length)
//    {
//        setTimeout(function(){$('.ets_hd_alert_success').remove()},3000);
//    }
//    else
//    {
//        if($('.alert.alert-success').length)
//        {
//            setTimeout(function(){$('.alert.alert-success').remove()},3000);
//        }
//    }
    if (ets_hd_fn) {
        ets_hd_fn.init();
    }
    if ($.fn.select2) {
        $('#ets_hd_ticket_form select').select2();//, #form-ets_hd_ticket select
    }
    var datepicker = $('.datepicker');
    if (datepicker.length > 0 && $.fn.datepicker) {
        datepicker.datepicker({
            prevText: '',
            nextText: '',
            dateFormat: 'yy-mm-dd',
            timeFormat: 'hh:mm:ss',
        });
    }

    var datetimepicker = $('.datetimepicker');
    if (datetimepicker.length > 0 && $.fn.datetimepicker) {
        datetimepicker.datetimepicker({
            prevText: '',
            nextText: '',
            dateFormat: 'yy-mm-dd',
            // Define a custom regional settings in order to use PrestaShop translation tools
            currentText: 'Now',
            closeText: 'Done',
            ampm: false,
            amNames: ['AM', 'A'],
            pmNames: ['PM', 'P'],
            timeFormat: 'hh:mm:ss tt',
            timeSuffix: '',
            timeOnlyTitle: 'Choose Time',
            timeText: 'Time',
            hourText: 'Hour',
            minuteText: 'Minute',
        });
    }

    $(document).on('click', 'a.ets_hd_status_ticket', function (e) {
        e.preventDefault();
        var ele = $(this),
            url = ele.attr('href'),
            parentUL = ele.parents('ul.dropdown_list_ticket')
        ;
        if (!ele.hasClass('active') && url) {
            ele.addClass('active');
            $.ajax({
                url: url,
                type: 'post',
                data: {
                    ajax: 1,
                    action: 'statusTicket',
                },
                dataType: 'json',
                success: function (json) {
                    ele.removeClass('active');
                    if (json) {
                        if (json.errors) {
                            showErrorMessage(json.errors);
                        } else {
                            if (json.msg) {
                                showSuccessMessage(json.msg);
                            }
                            if (json.status) {
                                var tr = ele.parents('tr');
                                tr.find('td.status').html('<span class="' + json.status.id + '">' + json.status.name + '</span>')
                            }
                            ele.parent('li').hide();
                            parentUL.find('.ets_hd_status_ticket.' + (ele.hasClass('open') ? 'closed' : 'open')).parent('li').show();
                        }
                    }
                },
                error: function () {
                    ele.removeClass('active');
                }
            })
        }
    });

    $(document).on('keyup input', 'input[type=text], textarea', function () {
        var ele = $(this);
        if (ele.attr('id') !== '' && parseInt(ele.attr('maxlength')) > 0) {
            $('.help-block-character[data-id=' + ele.attr('id') + '] .current-character').text(ele.val().length);
        }
    });

    $(document).on('click', '.ets_hd_load_more_message', function (e) {
        e.preventDefault();
        var ele = $(this),
            href = ele.attr('href')
        ;
        if (!ele.hasClass('active')) {
            ele.addClass('active');
            $.ajax({
                type: 'get',
                url: href,
                data: {
                    ajax: 1,
                    action: 'paginationMessage'
                },
                dataType: 'json',
                success: function (json) {
                    ele.removeClass('active');
                    if (json) {
                        if (json.errors) {
                            showErrorMessage(json.errors);
                        } else {
                            var _wrap_content = $('.ets_hd_wrap_messages');
                            if (json.messages && _wrap_content.length > 0) {
                                _wrap_content.prepend(json.messages);
                            }
                            if (json.next_url !== '') {
                                ele.attr('href', json.next_url);
                            } else
                                ele.remove();
                        }
                    }
                },
                error: function () {
                    ele.removeClass('active');
                }
            });
        }
    });

    $(document).on('click', 'button[name=submitAddTicket]', function (e) {
        var ele = $(this),
            form = ele.parents('form').eq(0)
        ;
        if (form.hasClass('ets_hd_alert')) {
            $('html, body').animate({
                scrollTop: form.find('.ets_hd_alert').first().offset()
            }, 1500);
            e.preventDefault();
        }
    });

    $(document).on('change', '.ets_hd_ticket_upload_file', function () {
        var ele = $(this),
            wrap_file = ele.parent(),
            id = ele.attr('id'),
            helpBlock = wrap_file.find('.help-block'),
            form = ele.parents('form').eq(0)
        ;
        if (this.files[0]) {
            //form.removeClass('ets_hd_alert');
            //wrap_file.removeClass('ets_hd_alert');
            wrap_file.find('.ets_hd_upload_file, .error').remove();
            if (wrap_file.find('.ets_hd_ticket_delete_file').length <= 0) {
                ele.after('<span class="ets_hd_ticket_delete_file" data-ref="' + id + '"><svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 1376v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm-544-992h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg></span>');
            }
            if (this.files[0].size > parseInt(ets_hd_post_max_size)) {
                //wrap_file.addClass('ets_hd_alert');
                //form.addClass('ets_hd_alert');
                if (wrap_file.find('p.error').length <= 0) {
                    helpBlock.before('<p class="error">');
                }
                wrap_file.find('p.error').html(ets_hd_max_file_size_msg);
            } else {
                var extension = this.files[0].name.toLowerCase().substr((this.files[0].name.lastIndexOf('.') + 1));
                if (ets_hd_allow_ext_files.indexOf(extension) < 0) {
                    //wrap_file.addClass('ets_hd_alert');
                    //form.addClass('ets_hd_alert');
                    if (wrap_file.find('p.error').length <= 0) {
                        helpBlock.before('<p class="error">');
                    }
                    wrap_file.find('p.error').html(ets_hd_allow_ext_file_msg);
                }
            }
        }
    });
    $(document).on('click', '.ets_hd_ticket_delete_file', function () {
        var ele = $(this),
            upload_file = $(this).data('ref'),
            wrap_file = ele.parent()
        ;
        if (upload_file !== '') {
            $('input[name=' + upload_file + ']').val('');
            $('input[name=' + upload_file + '_deleted]').val(1);
            wrap_file.find('.filename').html('');
            wrap_file.removeClass('ets_hd_alert').find('.file, .ets_hd_ticket_delete_file, p.error').remove();
        }
    });

    $(document).on('click', '.ets_hd_delete_ticket', function (e) {
        if (!confirm(ets_hd_delete_confirm)) {
            e.preventDefault();
        }
    });

    $(document).on('click', '#submitBulkclosedets_hd_ticket', function (e) {
        e.preventDefault();
        if ($('input[name="ets_hd_ticket_groupBox[]"]:checked').length <= 0) {
            if (typeof ets_hd_not_item_selected !== "undefined") {
                alert(ets_hd_not_item_selected);
            }
        } else {
            sendBulkAction($(this).closest('form').get(0), $(this).attr('id'));
        }
    });

    $(document).on('click', '#submitBulkdeleteets_hd_ticket', function (e) {
        e.preventDefault();
        var ele = $(this),
            confirmMsg = ele.data('confirm');

        if ($('input[name="ets_hd_ticket_groupBox[]"]:checked').length <= 0) {
            if (typeof ets_hd_not_item_selected !== "undefined") {
                alert(ets_hd_not_item_selected);
            }
        } else if (confirmMsg === '' || confirm(confirmMsg)) {
            sendBulkAction($(this).closest('form').get(0), $(this).attr('id'));
        }
    });
    $(document).on('click','.list-tickets .hd-item-ticket',function(){
        if(!$(this).hasClass('current') && !$('.hd-content-ticket').hasClass('loading'))
        {
            $('.hd-content-ticket').addClass('loading');
            var $this_ticket = $(this);
            var IDTicket = $(this).data('id');
            $.ajax({
                type: 'post',
                url: '',
                data: {
                    ajax: 1,
                    id_ticket: IDTicket,
                    action: 'viewTickets'
                },
                dataType: 'json',
                success: function (json) {
                    $('.hd-content-ticket').removeClass('loading'); 
                    $('.list-tickets .hd-item-ticket').removeClass('current');
                    $this_ticket.addClass('current');
                    $this_ticket.removeClass('ets-hd-no-read-ticket');
                    if(json.ticket_content)
                    {
                        $('.hd-content-ticket').html(json.ticket_content);
                    }
                },
                error: function () {
                    $('.hd-content-ticket').removeClass('loading'); 
                }
            });
        }
    });
    $(document).on('click', 'a.ets_hd_view_orders, .ets_hd_pagination_footer.orders a.pagination-items-page, .ets_hd_pagination_footer.orders a.pagination-link', function (e) {
        e.preventDefault();
        var ele = $(this),
            href = ele.attr('href')
        ;
        if (!ele.hasClass('active')) {
            ele.addClass('active');
            $.ajax({
                type: 'get',
                url: href,
                data: {
                    ajax: 1,
                    action: 'viewOrders'
                },
                dataType: 'json',
                success: function (json) {
                    ele.removeClass('active');
                    if (json) {
                        var _wrap_content = $('.ets_hd_content'), _overload = $('.ets_hd_overload');
                        if (json.list && _wrap_content.length > 0) {
                            _wrap_content.html(json.list);
                            _overload.addClass('active');
                        }
                    }
                },
                error: function () {
                    ele.removeClass('active');
                }
            });
        }
    });
    $(document).on('click', '.ets_hd_product_search:not(.product_ref) .ets_hd_product_item .remove_ctm', function () {
        $(this).parents('.ets_hd_product_search').removeClass('active').find('.ets_hd_product_item').remove();
        $('#id_product').val(0);
    });
    $(document).on('click', '.ets_hd_mark_as_replied', function (e) {
        e.preventDefault();
        var button = $(this),
            post_url = button.attr('href')
        ;
        if (!button.hasClass('active') && post_url !== '') {
            button.addClass('active');
            $.ajax({
                type: 'POST',
                url: post_url,
                data: {ajax: 1},
                dataType: 'json',
                success: function (json) {
                    button.removeClass('active');
                    if (json) {
                        if (json.errors) {
                            showErrorMessage(json.errors);
                        } else {
                            if (json.msg) {
                                button.after('<p class="ets_hd_alert_success">' + json.msg + '</p>');
                            }
                            button.remove();
                        }
                    }
                },
                error: function () {
                    button.removeClass('active');
                }
            })
        }
    });
    $(document).on('click', 'button[name=submitAddMessage]', function (e) {
        e.preventDefault();
        var button = $(this),
            form = button.parents('form')
        ;
        if (form.hasClass('ets_hd_alert')) {
            $('html, body').animate({
                scrollTop: form.find('.ets_hd_alert').first().offset()
            }, 1500);
        } else if (!button.hasClass('active') && form.length > 0) {
            button.addClass('active');
            $('.panel-footer .ets_hd_alert').remove();

            var formData = new FormData(form.get(0));
            if (!formData.get('message') && $('#etsTransOriginMessage').length && $('#etsTransOriginMessage').val()){
                formData.set('message', $('#etsTransOriginMessage').val());
            }
            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formData,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function (json) {
                    button.removeClass('active');
                    if (json) {
                        if (json.errors) {
                            $message = $('<div class="ets_hd_alert"><p class="alert alert-danger"><button class="close" type="button" data-dismiss="alert">×</button>' + json.errors + '</p></div>');
                            $('.panel-footer').prepend($message);
                            setTimeout(function(){$message.remove()},3000);
                        }
                        else if(json.warnings)
                        {   $message = $('<div class="ets_hd_alert"><p class="alert alert-popup alert-warning"><button class="close" type="button" data-dismiss="alert">×</button>'+json.success +'<br/>'+ json.warnings + '</p></div>');
                            $('.panel-footer').prepend($message);
                            //setTimeout(function(){$message.remove()},3000);
                        }
                        else if(json.success)
                        {
                            $message = $('<div class="ets_hd_alert"><p class="alert alert-popup alert-success"><button class="close" type="button" data-dismiss="alert">×</button>'+json.success+'</p></div>');
                            $('.panel-footer').prepend($message);
                            setTimeout(function(){$message.remove()},3000);
                        }  
                        if(json.last_date)
                            $('input[name="last_date"]').val(json.last_date);
                        if(json.new_messages)
                        {
                            ets_hd_ticket.displayNewMessage(json.new_messages);
                        }
                        if(json.tickets)
                        {
                            $(json.tickets).each(function(){
                                if($('.list-tickets .hd-item-ticket.item-ticket-'+this.id_ets_hd_ticket).length>0)
                                {
                                    $('.list-tickets .hd-item-ticket.item-ticket-'+this.id_ets_hd_ticket).remove();
                                }
                                $('.list-tickets').prepend(this.row_content);
                            });
                        }
                        
                        if (json.message) {
                            //const msg = $(json.message);
//                            if ($('.ets_hd_message:last').data('uiq') === json.unique) {
//                                msg.find('.ets_hd_profile').remove();
//                            }
//                            $('.ets_hd_wrap_messages').append(msg);
                            form[0].reset();
                            form.find('.ets_hd_ticket_delete_file').remove();
                            form.find('.uploader .filename').html('');
                        }
                    }
                },
                error: function () {
                    button.removeClass('active');
                }
            });
        }
    });

    $(document).on('click', '.ets-hd-ticket-rating.customer .ets-hd-star', function () {
        ets_hd_selected_star = parseInt($(this).data('number'));
        $('.ets-hd-ticket-rating.customer .ets-hd-rating').attr('data-rate', ets_hd_selected_star);
        var ele = $(this);
        if (!ele.hasClass('active')) {
            ele.addClass('active');
            $('.ets-hd-form-ticket .ets-hd-alert').remove();
            $.ajax({
                type: 'POST',
                data: {
                    ajax: 1,
                    action: 'ratingTicket',
                    rating: ets_hd_selected_star,
                },
                dataType: 'json',
                success: function (json) {
                    ele.removeClass('active');
                    if (json) {
                        if (json.errors) {
                            $('.ets-hd-form-ticket').prepend('<div class="ets-hd-alert error"><p class="alert alert-danger"><button class="close" type="button" data-dismiss="alert">×</button> ' + json.errors + '</p></div>');
                        } else {
                            if (json.msg) {
                                success_html = $('<div class="ets-hd-alert success"><p class="alert alert-success"><button class="close" type="button" data-dismiss="alert">×</button> ' + json.msg + '</p></div>');
                                $('.ets-hd-form-ticket').prepend(success_html);
                                setTimeout(function(){success_html.remove();},3000);
                            }
                        }
                    }
                },
                error: function () {
                    ele.removeClass('active');
                }
            });
        }
    });
    $(document).on('click','.ets_hd_reload_ticket',function(e){
        e.preventDefault(); 
        ets_hd_ticket.loadTicket(false);
    });
    if($('.ets_hd_reload_ticket').length && ETS_HD_TIME_RELOAD_LIST_TICKET>0)
    {
        setInterval(ets_hd_ticket.loadTicket,ETS_HD_TIME_RELOAD_LIST_TICKET*60*1000,true);
    }
    if($('button[name="submitAddMessage"]').length && ETS_HD_TIME_RELOAD_LIST_MESSAGE > 0)
    {
        setInterval(ets_hd_ticket.loadMessageTicket,ETS_HD_TIME_RELOAD_LIST_MESSAGE*60*1000);
    }
    $(document).on('mouseleave', '.ets-hd-ticket-rating.customer .ets-hd-star', function () {
        $('.ets-hd-ticket-rating.customer .ets-hd-rating').attr('data-rate', ets_hd_selected_star);
    });

    $(document).on('mouseover', '.ets-hd-ticket-rating.customer .ets-hd-star', function () {
        $('.ets-hd-ticket-rating.customer .ets-hd-rating').attr('data-rate', $(this).data('number'));
    });

    var ets_hd_selected_status = $('select.ets_hd_status').val() || 'open';
    $(document).on('change', 'select.ets_hd_status', function () {
        var ele = $(this);
        if (confirm(ets_hd_change_status_msg)) {
            if (!ele.hasClass('active')) {
                ele.addClass('active');
                $('.ets-hd-form-ticket .ets-hd-alert').remove();
                $.ajax({
                    type: 'POST',
                    data: {
                        ajax: 1,
                        action: 'statusTicket',
                        status: ele.val(),
                    },
                    dataType: 'json',
                    success: function (json) {
                        ele.removeClass('active');
                        if (json) {
                            if (json.errors) {
                                $('.ets-hd-form-ticket').prepend('<div class="ets-hd-alert error"><p class="alert alert-danger"><button class="close" type="button" data-dismiss="alert">×</button> ' + json.errors + '</p></div>');
                            } else {
                                if (json.msg) {
                                    success_text = $('<div class="ets-hd-alert success"><p class="alert alert-success"><button class="close" type="button" data-dismiss="alert">×</button> ' + json.msg + '</p></div>');
                                    $('.ets-hd-form-ticket').prepend(success_text);
                                    setTimeout(function(){success_text.remove();},3000);
                                }
                                ets_hd_selected_status = ele.val();
                            }
                        }
                    },
                    error: function () {
                        ele.removeClass('active');
                    }
                });
            }
        } else
            ele.val(ets_hd_selected_status);
    });

    var ets_hd_selected_priority = $('select.ets_hd_priority').val() || 'medium';
    $(document).on('change', 'select.ets_hd_priority', function () {
        var ele = $(this);
        if (confirm(ets_hd_change_priority_msg)) {
            if (!ele.hasClass('active')) {
                ele.addClass('active');
                $('.ets-hd-form-ticket .ets-hd-alert').remove();
                $.ajax({
                    type: 'POST',
                    data: {
                        ajax: 1,
                        action: 'priorityTicket',
                        priority: ele.val(),
                    },
                    dataType: 'json',
                    success: function (json) {
                        ele.removeClass('active');
                        if (json) {
                            if (json.errors) {
                                $('.ets-hd-form-ticket').prepend('<div class="ets-hd-alert"><p class="alert alert-danger"><button class="close" type="button" data-dismiss="alert">×</button> ' + json.errors + '</p></div>');
                            } else {
                                if (json.msg) {
                                    success_text = '<div class="ets-hd-alert success"><p class="alert alert-success"><button class="close" type="button" data-dismiss="alert">×</button> ' + json.msg + '</p></div>';
                                    $('.ets-hd-form-ticket').prepend(success_text);
                                    setTimeout(function(){success_text.remove();},3000);
                                }
                                ets_hd_selected_priority = ele.val();
                            }
                        }
                    },
                    error: function () {
                        ele.removeClass('active');
                    }
                });
            }
        } else
            ele.val(ets_hd_selected_priority);
    });
    $(document).on('keyup','#search_customer_ticket',function(e){
        if(e.keyCode==13)
        {
            e.preventDefault();
            $('#search_id_customer_ticket_hidden').val('');
            $('#search_customer_ticket_hidden').val($(this).val()).change();
        }
    });
    $(document).on('click','.view_all_ticket',function(e){
        e.preventDefault();
        $('#search_customer_ticket').val($(this).data('email'));
        $('#search_id_customer_ticket_hidden').val('');
        $('#search_customer_ticket_hidden').val($(this).data('email')).change();
    });
    $(document).on('change','#search_customer_ticket_hidden',function(){
        var text_search = $(this).val();
        var id_customer_search = $('#search_id_customer_ticket_hidden').val();
        $.ajax({
            type: 'POST',
            data: {
                ajax: 1,
                search : text_search,
                processSearchTicket: 1,
                id_customer:id_customer_search,
                id_ticket:$('input[name="id_ticket"]').val(),
            },
            dataType: 'json',
            success: function (json) {
                $('.hd-list-tickets .list-tickets').html(json.list_tickets);
            }
        });
    });
});
var ets_hd_ticket = {
    displayNewMessage: function(messages)
    {
        $(messages).each(function(){
            const msg = $(this.message);
            if ($('.ets_hd_message:last').data('uiq') && $('.ets_hd_message:last').data('uiq') === this.unique) {
                msg.find('.ets_hd_profile').remove();
            }
            if(!$('.ets_hd_message[data-id="'+this.id_ets_hd_ticket_message+'"]').length)
            {
                if(msg.find('.ets_hd_mark_as_replied').length)
                {
                    $('.ets_hd_mark_as_replied').remove();
                }
                $('.ets_hd_wrap_messages').append(msg);
            }
        });
        
    },
    loadMessageTicket: function()
    {
        $.ajax({
            type: 'POST',
            data: {
                ajax: 1,
                id_ticket : $('input[name="id_ticket"]').val(),
                processLoadMessageTicket: 1,
                last_date: $('input[name="last_date"]').val(),
            },
            dataType: 'json',
            success: function (json) {
                if(json.new_messages)
                {
                    ets_hd_ticket.displayNewMessage(json.new_messages);
                }
                if(json.tickets)
                {
                    $(json.tickets).each(function(){
                        if($('.list-tickets .hd-item-ticket.item-ticket-'+this.id_ets_hd_ticket).length>0)
                        {
                            $('.list-tickets .hd-item-ticket.item-ticket-'+this.id_ets_hd_ticket).remove();
                        }
                        $('.list-tickets').prepend(this.row_content);
                    });
                }
                if(json.last_date)
                    $('input[name="last_date"]').val(json.last_date);
            }
        });
    },
    loadTicket : function(autoload)
    {
        if(!autoload)
        {
            if($('.ets_hd_reload_ticket').hasClass('active') || $('.ets_hd_reload_ticket').length==0)
                return false;
            $('.ets_hd_reload_ticket').addClass('active');
        }
        $.ajax({
            type: 'POST',
            data: {
                ajax: 1,
                processLoadTicket: 1,
                last_reload_ticket: $('.ets_hd_reload_ticket').attr('data-last_reload'),
            },
            dataType: 'json',
            success: function (json) {
                if(json.tickets)
                {
                    if($('.ets_hd_menu_item .no_read').length)
                        var number_ticket_no_read = parseInt($('.ets_hd_menu_item .no_read').html());
                    else
                        var number_ticket_no_read = 0;
                    $(json.tickets).each(function(){
                        if($('.ets-hd-ticket-'+this.id_ets_hd_ticket).length==0)
                        {
                            $('#form-ets_hd_ticket tbody').prepend(this.row_content);
                            number_ticket_no_read++;
                        }
                        else
                        {
                            $('#form-ets_hd_ticket tbody .ets-hd-ticket-'+this.id_ets_hd_ticket).replaceWith(this.row_content);
                            /*
                            var last_message = this.last_message.length <=100 ? this.last_message : this.last_message.substr(0,100)+'...';
                            if(this.last_message_attachment_name)
                            {
                                last_message +='</br>';
                                last_message +='<a class="link_file" href="'+this.last_message_attachment_name+'">';
								last_message +='<span class="icon_svg">';							
								last_message +='<svg width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M768 384v-128h-128v128h128zm128 128v-128h-128v128h128zm-128 128v-128h-128v128h128zm128 128v-128h-128v128h128zm700-388q28 28 48 76t20 88v1152q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1600q0-40 28-68t68-28h896q40 0 88 20t76 48zm-444-244v376h376q-10-29-22-41l-313-313q-12-12-41-22zm384 1528v-1024h-416q-40 0-68-28t-28-68v-416h-128v128h-128v-128h-512v1536h1280zm-627-721l107 349q8 27 8 52 0 83-72.5 137.5t-183.5 54.5-183.5-54.5-72.5-137.5q0-25 8-52 21-63 120-396v-128h128v128h79q22 0 39 13t23 34zm-141 465q53 0 90.5-19t37.5-45-37.5-45-90.5-19-90.5 19-37.5 45 37.5 45 90.5 19z"/></svg>';
                                last_message +='</span>';								
								last_message += this.last_message_attachment_name;
								last_message +='</a>'; 
                            }
                            if(this.attachment)
                            {
                                last_message +='</br>';
                                last_message += this.attachment;
                            }
                            if(this.display_status)
                            {
                                $('.ets-hd-ticket-'+this.id_ets_hd_ticket+' .status').html('<span class="status_'+this.display_status.id+'">'+this.display_status.name+'</span>');
                            }
                            $('.ets-hd-ticket-'+this.id_ets_hd_ticket+' .last_message').html(last_message);
                            $('.ets-hd-ticket-'+this.id_ets_hd_ticket+' .last_date_message').html(this.last_date_message);
                            */
                            if(!$('.ets-hd-ticket-'+this.id_ets_hd_ticket).hasClass('ets-hd-no-read-ticket'))
                            {
                                $('.ets-hd-ticket-'+this.id_ets_hd_ticket).addClass('ets-hd-no-read-ticket');
                                number_ticket_no_read++;
                            }
                        }
                    });
                    if(number_ticket_no_read)
                    {
                        if($('.ets_hd_menu_item .no_read').length)
                            $('.ets_hd_menu_item .no_read').html(number_ticket_no_read);
                        else
                            $('.ets_hd_menu_item.tickets a').append('<span class="no_read">'+number_ticket_no_read+'</span>');
                    }
                    $('.ets_hd_pagination_footer .bulk-actions').show();
                    if($('.no_data').length)
                    {
                        $('.no_data').parents('tr').hide();
                    }
                }
                $('.ets_hd_reload_ticket').attr('data-last_reload',json.current_date);
                if(!autoload)
                {
                    $('.ets_hd_reload_ticket').removeClass('active');
                    var success_text = $('<div class="ets-hd-alert success"><p class="alert alert-success"><button class="close" type="button" data-dismiss="alert">×</button> ' + json.msg + '</p></div>');
                    if($('#form-ets_hd_ticket').length)
                        $('#form-ets_hd_ticket').prepend(success_text);
                    else
                        $('body').prepend(success_text);
                    setTimeout(function(){success_text.remove();},3000);
                }
            },
            error: function () {
            }
        });
    }
}
