{*
* 2007-2022 ETS-Soft
*
* NOTICE OF LICENSE
*
* This file is not open source! Each license that you purchased is only available for 1 wesite only.
* If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
* You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
* 
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs, please contact us for extra customization service at an affordable price
*
*  @author ETS-Soft <etssoft.jsc@gmail.com>
*  @copyright  2007-2022 ETS-Soft
*  @license    Valid for 1 website (or project) for each purchase of license
*  International Registered Trademark & Property of ETS-Soft
*}

{extends file="helpers/form/form.tpl"}
{block name="legend"}
    {$smarty.block.parent}
    {if isset($sub_tabs) && $sub_tabs|count > 0}
		<ul class="ets-hd-nav-tabs">
            {foreach from=$sub_tabs key='id' item='tab'}
				<li class="ets-hd-nav-tab {$id|escape:'quotes':'UTF-8'}{if $current_tab|trim === $id|trim} active{/if}"
				    data-tab="{$id|escape:'quotes':'UTF-8'}">{$tab|escape:'quotes':'UTF-8'}</li>
            {/foreach}
		</ul>
		<input id="current_tab" name="current_tab" value="{$current_tab|escape:'html':'UTF-8'}" type="hidden"/>
    {/if}
{/block}
{block name='input'}
    {if $input.name == 'id_customer' && isset($input.autocomplete) && $input.autocomplete}
		<div class="input-group">
			<input type="text" name="search_customer"
			       class="search_customer"{if isset($input.placeholder)} placeholder="{$input.placeholder|escape:'html':'UTF-8'}"{/if}
			       autocomplete="off">
			<span class="input-group-addon">
				<i class="ets_svg">
					<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1216 832q0-185-131.5-316.5t-316.5-131.5-316.5 131.5-131.5 316.5 131.5 316.5 316.5 131.5 316.5-131.5 131.5-316.5zm512 832q0 52-38 90t-90 38q-54 0-90-38l-343-342q-179 124-399 124-143 0-273.5-55.5t-225-150-150-225-55.5-273.5 55.5-273.5 150-225 225-150 273.5-55.5 273.5 55.5 225 150 150 225 55.5 273.5q0 220-124 399l343 343q37 37 37 90z"/></svg>
				</i>
			</span>
		</div>
		<input type="hidden" id="id_customer" name="id_customer"
		       value="{if isset($fields_value[$input.name])}{$fields_value[$input.name]|escape:'html':'UTF-8'}{/if}"/>
		<div class="ets_pc_customers_list">
            {if isset($customers) && $customers}
                {foreach from=$customers item='customer'}
                    {include file="./customer.tpl" customer=$customer}
                {/foreach}
            {/if}
            {include file="./customer.tpl" customer = array()}
		</div>
    {elseif $input.type == 'checkbox'}
        {foreach $input.values.query as $value}
            {assign var=id_checkbox value=$value[$input.values.id]}
			<div class="checkbox{if isset($input.expand) && strtolower($input.expand.default) == 'show'} hidden{/if}">
                {strip}
					<label for="{$id_checkbox|escape:'html':'UTF-8'}">
						<input type="checkbox" name="{$input.name|escape:'html':'UTF-8'}[]" id="{$id_checkbox|escape:'html':'UTF-8'}"
						       class="{if isset($input.class)}{$input.class|escape:'html':'UTF-8'}{/if}"
						       value="{$id_checkbox|escape:'html':'UTF-8'}" {if isset($fields_value[$input.name]) && in_array($id_checkbox, $fields_value[$input.name])} checked="checked"{/if} />
                        {$value[$input.values.name]|escape:'html':'UTF-8'}
					</label>
                {/strip}
			</div>
        {/foreach}
    {elseif $input.name|trim == 'ETS_HD_CRONJOB_SECURE_TOKEN'}
	    <div class="form-group">
            <div class="col-lg-4">
                {$smarty.block.parent}
            </div>
		    <div class="col-lg-3">
			    <button type="button" name="ets_hd_general_token" class="btn btn-default">
					<i class="ets_svg_fill_gray ets_svg_hover_fill_white lh_16">
				    	<svg class="w_14 h_14" width="12" height="12" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1639 1056q0 5-1 7-64 268-268 434.5t-478 166.5q-146 0-282.5-55t-243.5-157l-129 129q-19 19-45 19t-45-19-19-45v-448q0-26 19-45t45-19h448q26 0 45 19t19 45-19 45l-137 137q71 66 161 102t187 36q134 0 250-65t186-179q11-17 53-117 8-23 30-23h192q13 0 22.5 9.5t9.5 22.5zm25-800v448q0 26-19 45t-45 19h-448q-26 0-45-19t-19-45 19-45l138-138q-148-137-349-137-134 0-250 65t-186 179q-11 17-53 117-8 23-30 23h-199q-13 0-22.5-9.5t-9.5-22.5v-7q65-268 270-434.5t480-166.5q146 0 284 55.5t245 156.5l130-129q19-19 45-19t45 19 19 45z"/></svg>
					</i> {l s='General' mod='ets_helpdesk'}
			    </button>
		    </div>
	    </div>
    {elseif $input.name|trim == 'ETS_HD_CLEAR_FILE_UPLOAD'}
	    <div class="input-group">
            {$smarty.block.parent}
		    <button type="button" name="ets_hd_clear_file_upload" class="btn btn-default">
				<i class="ets_svg_fill_gray ets_svg_hover_fill_white lh_16">
			    	<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 736v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm128 724v-948h-896v948q0 22 7 40.5t14.5 27 10.5 8.5h832q3 0 10.5-8.5t14.5-27 7-40.5zm-672-1076h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg>
				</i> {l s='Delete attachments' mod='ets_helpdesk'}
		    </button>
	    </div>
    {else}
        {$smarty.block.parent}
        {if isset($input.friend_urls) && $input.friend_urls}
			<div class="help-block">
                {if $languages}
                    {foreach from=$languages item='language'}
						<div class="translatable-field lang-{$language.id_lang|intval}"{if $language.id_lang != $defaultFormLanguage} style="display:none"{/if}>
							<a target="_blank" id="{$input.name|escape:'html':'UTF-8'}_LINK_{$language.id_lang|intval}" rel="noreferrer  noopener"
							   href="{$input.friend_urls[$language.id_lang] nofilter}"
							   data-href="">{$input.friend_urls[$language.id_lang] nofilter}</a>
						</div>
                    {/foreach}
                {/if}
			</div>
        {/if}
        {if $input.type == 'file'}
            {if isset($input.reader)}
				<div class="ets_hd_reader_image {$input.name|lower|escape:'html':'UTF-8'}">
                    {if isset($fields_value[$input.name]) && trim($fields_value[$input.name]) !== ''}
						<img src="{$input.base_uri|cat:$fields_value[$input.name] nofilter}" style="max-width: 110px;"
						     class="image-loading"/>
                        {if !isset($input.required) || !$input.required}
							<span class="ets_hd_delete_avatar" data-ref="{$input.name|escape:'html':'UTF-8'}"
							      title="Delete"><svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 736v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm128 724v-948h-896v948q0 22 7 40.5t14.5 27 10.5 8.5h832q3 0 10.5-8.5t14.5-27 7-40.5zm-672-1076h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg></span>
                        {/if}
                    {elseif isset($input.default_image) && $input.default_image}
						<img src="{$input.default_image nofilter}" style="max-width: 110px;" class="image-loading"/>
                    {/if}
				</div>
            {/if}
            {if !isset($input.required) || !$input.required}
				<input type="hidden" name="{$input.name|cat:'_DELETED'|escape:'html':'UTF-8'}" value="0">
            {/if}
			<p class="help-block">{l s ='Accepted formats: pdf, gif, png, jpg. Limit %s' sprintf=[$PS_ATTACHMENT_MAXIMUM_SIZE] mod='ets_helpdesk'}</p>
        {/if}
	    {if $input.name|trim == 'ETS_HD_CRONJOB_LOG'}
		    <button class="btn btn-default" name="ets_hd_clear_log" type="button">
				<i class="ets_svg_fill_gray ets_svg_hover_fill_white lh_16">
			    <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M704 736v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm256 0v576q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-576q0-14 9-23t23-9h64q14 0 23 9t9 23zm128 724v-948h-896v948q0 22 7 40.5t14.5 27 10.5 8.5h832q3 0 10.5-8.5t14.5-27 7-40.5zm-672-1076h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z"/></svg>
				</i> {l s='Clear log' mod='ets_helpdesk'}
		    </button>
	    {/if}
    {/if}
{/block}
{block name="input_row"}
    {if isset($sub_tabs) && $sub_tabs}
        {if !isset($form_group_tab)}
            {assign var="form_group_tab" value=$input.group}
			<div class="form-wrapper-group-tab {$input.group|escape:'quotes':'UTF-8'}{if $current_tab|escape:'quotes':'UTF-8' === $input.group|escape:'quotes':'UTF-8'} active{/if}" data-tab="{$input.group|escape:'quotes':'UTF-8'}">
        {/if}
        {if $form_group_tab == $input.group}
            {if isset($input.group_title) && $input.group_title|trim !== ''}
				<h4 class="ets_hd_title_block">{$input.group_title|escape:'quotes':'UTF-8'}</h4>
            {/if}
            {if $input.name|trim == 'ETS_HD_CRONJOB_SECURE_TOKEN'}
		        <div class="form-group">
			        <p class="ets-hd-text-strong mb-10"><span style="color: red;">*</span> {l s='Some important notes before setting Cronjob' mod='ets_helpdesk'}:</p>
			        <ul>
				        <li>{l s='Cronjob frequency should be at least twice per day, the recommended frequency is once per minute' mod='ets_helpdesk'}</li>
				        <li>{l s='How to setup a cronjob is different depending on your server. If you\'re using a Cpanel hosting, watch this video for more reference:' mod='ets_helpdesk'}
					        <a href="https://www.youtube.com/watch?v=bmBjg1nD5yA" target="_blank" rel="noreferrer noopener">https://www.youtube.com/watch?v=bmBjg1nD5yA</a> <br>
					        {l s='You can also contact your hosting provider to ask them for support on setting up the cronjob' mod='ets_helpdesk'}
				        </li>
			        </ul>
			        <p class="ets-hd-text-strong ets-hd-block mb-15"><span style="color: red;">*</span> {l s='Setup a cronjob as below on your server to automatically close support tickets after X days without customer reply. The time is configured on "Settings > Condiditon" tab.' mod='ets_helpdesk'}</p>
			        <p class="mb-15 ets-hd-block"><span class="ets-hd-text-bg-light-gray">* * * * * php {$base_dir nofilter} secure=<span class="ets-hd-cronjob-secure-value">{$fields_value[$input.name] nofilter}</span></span></p>
			        <p class="ets-hd-text-strong mb-10"><span style="color: red;">*</span> {l s='Execute the cronjob manually by clicking on the button below' mod='ets_helpdesk'}</p>
			        <a href="{$base_link nofilter}&secure={$fields_value[$input.name] nofilter}" class="btn btn-default js-ets-hd-run-cronjob"><i></i>{l s='Execute cronjob manually' mod='ets_helpdesk'}</a>
		        </div>
            {/if}
            {$smarty.block.parent}
        {elseif $form_group_tab != $input.group}
            {assign var="form_group_tab" value=$input.group}
			</div>
			<div class="form-wrapper-group-tab {$input.group|escape:'quotes':'UTF-8'}{if $current_tab|escape:'quotes':'UTF-8' === $input.group|escape:'quotes':'UTF-8'} active{/if}" data-tab="{$input.group|escape:'quotes':'UTF-8'}">
            {if !empty($input.group_title)}
				<h4 class="ets_hd_title_block">{$input.group_title|escape:'quotes':'UTF-8'}</h4>
            {/if}
            {if $input.name|trim == 'ETS_HD_TICKET_FIELD_LIST'}
				<div class="ets_hd_header">
					<a class="btn btn-primary addColumn"
					   href="{if isset($base_link)}{$base_link|cat:'&action=renderForm' nofilter}{/if}">
						<i class="ets_svg_fill_white lh_16">
							<svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg">
								<path d="M1600 736v192q0 40-28 68t-68 28h-416v416q0 40-28 68t-68 28h-192q-40 0-68-28t-28-68v-416h-416q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h416v-416q0-40 28-68t68-28h192q40 0 68 28t28 68v416h416q40 0 68 28t28 68z"/>
							</svg>
						</i> {l s='Add field' mod='ets_helpdesk'}
					</a>
				</div>
				<div class="ets_hd_columns">
					<table class="table">
						<thead>
						<tr class="nodrag nodrop">
							<th></th>
							<th class="center">{l s='ID' mod='ets_helpdesk'}</th>
							<th class="left">{l s='Title' mod='ets_helpdesk'}</th>
							<th class="left">{l s='Type' mod='ets_helpdesk'}</th>
							{*<th class="center">{l s='Field Type' mod='ets_helpdesk'}</th>
							<th class="center">{l s='Field length' mod='ets_helpdesk'}</th>
                            *}
							<th class="center">{l s='Display in field frontend' mod='ets_helpdesk'}</th>
							<th class="center">{l s='Display in field list backend' mod='ets_helpdesk'}</th>
							<th class="center">{l s='Require' mod='ets_helpdesk'}</th>
							<th class="center">{l s='Enable' mod='ets_helpdesk'}</th>
							<th></th>
						</tr>
						</thead>
						<tbody>
                        {if isset($columns) && is_array($columns) && $columns|count > 0}
                            {foreach from=$columns item='column'}
                                {include file="./list-column-item.tpl" column=$column}
                            {/foreach}
                        {else}
							<tr class="ets_hd_column empty">
								<td colspan="10">
									<p class="no_data">{l s='Field list is empty' mod='ets_helpdesk'}</p>
								</td>
							</tr>
                        {/if}
						</tbody>
					</table>
				</div>
            {else}{$smarty.block.parent}{/if}
        {/if}
        {if $input.name == 'ETS_HD_BUTTON_SUBMIT_LABEL'}
			</div>
        {/if}
    {else}
        {if $input.name|trim == 'ETS_HD_CRONJOB_SECURE_TOKEN'}
		        <div class="form-group">
			        <p class="ets-hd-text-strong mb-10"><span style="color: red;">*</span> {l s='Some important notes before setting Cronjob' mod='ets_helpdesk'}:</p>
			        <ul>
				        <li>{l s='Cronjob frequency should be at least twice per day, the recommended frequency is once per minute' mod='ets_helpdesk'}</li>
				        <li>{l s='How to setup a cronjob is different depending on your server. If you\'re using a Cpanel hosting, watch this video for more reference:' mod='ets_helpdesk'}
					        <a href="https://www.youtube.com/watch?v=bmBjg1nD5yA" target="_blank" rel="noreferrer noopener">https://www.youtube.com/watch?v=bmBjg1nD5yA</a> <br>
					        {l s='You can also contact your hosting provider to ask them for support on setting up the cronjob' mod='ets_helpdesk'}
				        </li>
			        </ul>
			        <p class="ets-hd-text-strong ets-hd-block mb-15"><span style="color: red;">*</span> {l s='Setup a cronjob as below on your server to automatically close support tickets after X days without customer reply. The time is configured on "Settings > Condiditon" tab.' mod='ets_helpdesk'}</p>
			        <p class="mb-15 ets-hd-block"><span class="ets-hd-text-bg-light-gray">* * * * * {$php_path|escape:'html':'UTF-8'} {$base_dir nofilter} secure=<span class="ets-hd-cronjob-secure-value">{$fields_value[$input.name] nofilter}</span></span></p>
			        <p class="ets-hd-text-strong mb-10"><span style="color: red;">*</span> {l s='Execute the cronjob manually by clicking on the button below' mod='ets_helpdesk'}</p>
			        <a href="{$base_link nofilter}&secure={$fields_value[$input.name] nofilter}" class="btn btn-default js-ets-hd-run-cronjob"><i></i>{l s='Execute cronjob manually' mod='ets_helpdesk'}</a>
		        </div>
        {/if}
        {$smarty.block.parent}
        {if $input.name=='ETS_HD_CRONJOB_LOG' &&  isset($cronjob_last) && $cronjob_last}
            <div class="mb-15 emp-block form-horizontal">
        		<p class="alert alert-info">{l s='Last time cronjob run' mod='ets_helpdesk'}: {$cronjob_last|escape:'html':'UTF-8'}</p>
        	</div>
        {/if}
    {/if}
{/block}